#include <iostream>
#include <vector>
#include <string>
#include <cassert>

using namespace std;

typedef unsigned long long ull;

int check_power2 (ull n)
{
    if (n == 0) return -1;
    int iters = 0;
    if (n == 1) return 0;
    while (n > 1)
    {
        if (n % 2 == 1)
            return -1;
        n /= 2;
        iters++;
    }
    return iters;
}

char get_switch_c (int s)
{
    if (s == -1)
        return '?';
    return s < 10 ? s + '0' : s - 10 + 'A';
}

//000000000000000000000000000000000001

void process_dataset (int n, int m, int q)
{
    vector<bool> switch_states (n, false), bulb_states (m, false);
    ull def = (1LL << n) - 1;
//    cerr << def << endl;
//    cerr << check_power2(def + 1) << endl;
    vector<ull> bulb_switch_masks (m, def);

    //cerr << def << endl;

    string inp;

    for (int i = 0; i < q; i++)
    {
        ull switchon_mask = 0, switchoff_mask = 0;
        cin >> inp;
        for (int j = 0; j < inp.length(); j++)
        {
            if (inp[j] == '1')
            {
                if (switch_states[j] == false)
                {
                    switchon_mask |= (1ll << j);
                    switch_states[j] = true;
                }
                else
                {
                    switchoff_mask |= (1ll << j);
                    switch_states[j] = false;
                }
            }
        }
        //cerr << switchon_mask << endl << switchoff_mask << endl;
        cin >> inp;

        for (int j = 0; j < inp.length(); j++)
        {
            char c = inp[j];
            if (c == '1')
            {
                bulb_switch_masks[j] &= ~switchoff_mask;
                if (bulb_states[j] == false)
                    bulb_switch_masks[j] &= switchon_mask;
                else
                    bulb_switch_masks[j] &= ~switchon_mask;
                bulb_states[j] = true;
            }
            else //if (c == '0')
            {
                bulb_switch_masks[j] &= ~switchon_mask;
                if (bulb_states[j] == true)
                    bulb_switch_masks[j] &= switchoff_mask;
                else
                    bulb_switch_masks[j] &= ~switchoff_mask;
                bulb_states[j] = false;
            }
        }

        /*cerr << "!" << endl;
        for (int j = 0; j < m; j++)
        {
            cerr << bulb_switch_masks[j] << endl;
        }
        cerr << "!" << endl;*/
    }

    for (int i = 0; i < m; i++)
    {
//        cerr << bulb_switch_masks[i] << " " << check_power2(bulb_switch_masks[i]) << endl;
        cout << get_switch_c(check_power2(bulb_switch_masks[i]));
    }
    cout << endl;
}

int main()
{
    int n, m, q;
    while (true)
    {
        cin >> n;
        if (n == 0)
            return 0;

        cin >> m >> q;
        process_dataset(n, m, q);
    }
}
